% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-learning.R
\name{horseshoe}
\alias{horseshoe}
\title{Horseshoe method for graphical structure inference}
\usage{
horseshoe(obj, Bbar = NULL, A = NULL, nu = 3, V = NULL, thr = 0.5)
}
\arguments{
\item{obj}{The carlasso_out object from CARlasso}

\item{Bbar}{Prior mean of regression coefficients, default all 0s}

\item{A}{Prior precision of regression coefficients, default 1e-8}

\item{nu}{Prior degree of freedom of the Wishart on precision matrix}

\item{V}{prior covariance matrix of the Wishart on precision matrix}

\item{thr}{threshold for horseshoe inference, default 0.5}
}
\value{
A \code{carlasso_out} object with learned binary adjacency matrix and multi-response linear regression MCMC out put
}
\description{
Horseshoe method for graphical structure inference
}
\details{
This method fits a linear regression with less informative prior on any parameters and compare the posterior mean with the LASSO result. If LASSO is comparably less than result without sparsity prior, we argue that the edge should be absent
}
\examples{
set.seed(42)
dt <- simu_AR1()
car_res <- CARlasso(y1+y2+y3+y4+y5~x1+x2+x3+x4+x5, data = dt, adaptive = TRUE)
car_res <- horseshoe(car_res)
plot(car_res)
}
