# CAWaR
[![CRAN version](https://www.r-pkg.org/badges/version/CAWaR)](https://CRAN.R-project.org/package=CAWaR)
[![CRAN downloads](https://cranlogs.r-pkg.org/badges/last-month/CAWaR?color=brightgreen)](https://CRAN.R-project.org/package=CAWaR)
[![CRAN downloads](http://cranlogs.r-pkg.org/badges/grand-total/CAWaR?color=brightgreen)](https://CRAN.R-project.org/package=CAWaR)

<p align="justify" style="line-height:200%;">
R package to support <b>Remote Sensing based Crop Mapping</b>. It was developed at the Department of Remote Sensing of the University of Würzburg, Germany, within the Central Asia Waters (<a href="http://www.cawa-project.net/">CAWa</a>) project funded by the <a href="https://www.auswaertiges-amt.de/en">German Federal Foreign Office</a>. It is part of the German Water Initiative for Central Asia (the so-called <a href="http://waterca.org/en/the-berlin-process/">Berlin process</a>), launched by the German Federal Foreign Office launched on the 1<sup>st</sup> of April of 2008 to support peaceful, sustainable and mutually beneficial management of transboundary water resources in Central Asia.
</p>
<p align="justify" style="line-height:200%;">
CAWaR was designed to support water management in Central Asia through the distinction and mapping of crop types. As water use requirements vary between crop types, knowing their spatial and temporal distribution helps decision makers build efficient water distribution practices in periods of water scarcity. In the context of climiate change, arid environments such as the one found in Central Asia demand efficient water management practices and toolboxes such as CAWaR make the work of local authorities much easier and consistent. CAWaR offers tools to consistently prepare ground-truth data, identify target classes and map and validate land cover information. In the near future, CAWaR will be published on CRAN and tutorial will be created describing how to use the package. If you are interested, go <a href="http://remote-sensing.eu/">here</a> and keep tabs on the website of our department. We will announce it there soon!
</p>

</br>

### How to install the package?
<p align="justify" style="line-height:200%;">
As CAWaR is not yet on CRAN, we can install it using devtools as shown below.
</p>

```r
devtools::install_github("RRemelgado/CAWaR")
```

</br>

### What else are we doing?
<p align="justify" style="line-height:200%;">
The Department of Remote Sensing of the University of Würzburg has developed other R packages that might interest you:
</p>

* <a href="https://bleutner.github.io/RStoolbox/">RStoolbox</a>
* <a href="https://github.com/cran/moveVis/">moveVis</a>
* <a href="https://github.com/RRemelgado/CAWaR">rsMove</a>
* <a href="https://github.com/RRemelgado/rsMove">fieldRS</a>

<p align="justify" style="line-height:200%;">
Click <a href="http://remote-sensing.eu/">here</a> for news on our department.
</p>

</br>
## Supported by
<p>
<a href="https://www.orn.mpg.de/en/"><img width="250" height="50" src="https://www.gfz-potsdam.de/fileadmin/_processed_/0/8/csm_CAWa_Logo_ae5c278929.png"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.geographie.uni-wuerzburg.de/en/fernerkundung/startseite/"><img width="130" height="80" src="https://www.uni-wuerzburg.de/typo3conf/ext/uw_sitepackage/Resources/Public/Images/uni-wuerzburg-logo.svg"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.dlr.de/eoc/en/desktopdefault.aspx/tabid-5278/8856_read-15911/"><img width="115" height="100" src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/f5/DLR_Logo.svg/744px-DLR_Logo.svg.png"></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://www.auswaertiges-amt.de/en/"><img width="190" height="70" src="https://ocdn.eu/images/pulscms/ZTA7MDA_/d9c29825-271b-4306-bbab-21068365b760.jpg"></a>
</p>
</br>
