% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_plus.r
\name{caPlus}
\alias{caPlus}
\title{Facility for interpretation-oriented CA scatterplot}
\usage{
caPlus(data, x = 1, y = 2, focus, row.suppl = FALSE, col.suppl = FALSE,
  oneplot = FALSE, inches = 0.35, cex = 0.5)
}
\arguments{
\item{data}{Object returned by the FactoMineR's CA() function (see example
provided below); if supplementary data (i.e., rows and/or columns) are
present, when using CA(), the analyst has to use the proper settings
required by that function.}

\item{x}{First dimensions to be plotted (x=1 by default).}

\item{y}{Second dimensions to be plotted (y=2 by default).}

\item{focus}{Takes "R" if the interest is in assessing the contribution of
rows to the definition of the dimensions, "C" if the interest is on the
columns.}

\item{row.suppl}{Takes TRUE or FALSE if supplementary row data are present or
absent (FALSE is the default value).}

\item{col.suppl}{Takes TRUE or FALSE if supplementary column data are present
or absent (FALSE is the default value).}

\item{oneplot}{Takes TRUE or FALSE if the analyst wants the four returned
charts on the same page (recommended) or on four separate windows (FALSE is
the default value).}

\item{inches}{Numerical value used to resize the size of the points' bubbles
(see below); the default value is 0.35.}

\item{cex}{Numerical value used to set the size of labels' font; the default
value is 0.50.}
}
\description{
This function allows to plot Correspondence Analysis scatterplots modified to
help interpreting the analysis' results. In particular, the function aims at
making easier to understand in the same visual context (a) which (say,
column) categories are actually contributing to the definition of given pairs
of dimensions, and (b) to eyeball which (say, row) categories are more
correlated to which dimension.
}
\examples{
data(greenacre_data)

#performs CA by means of FactoMineR's CA command, and store the result in the object named resCA.
library(FactoMineR)
resCA <- CA(greenacre_data, graph=FALSE)

#If supplementary data are present, the user has to specify which rows and/or columns 
#are supplmentary into this function (see FactoMineR's documentation).
caPlus(resCA, 1, 2, focus="C", row.suppl=FALSE, col.suppl=FALSE, oneplot=TRUE)

}
\seealso{
\code{\link{caPlot}} , \code{\link{caPercept}} , \code{\link[FactoMineR]{CA}}
}
\keyword{caPlus}
