% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_EEZs}
\alias{load_EEZs}
\title{Load Exclusive Economic Zones}
\usage{
load_EEZs()
}
\description{
Download the up-to-date spatial layer from the \href{http://gis.ccamlr.org/}{online CCAMLRGIS} and load it to your environment.
See examples for offline use. All layers use the Lambert azimuthal equal-area projection
 (EPSG:6932; CRS:+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs)
}
\examples{
 
\donttest{

#When online:
EEZs=load_EEZs()
plot(EEZs)

#If going offline in the future: load and save as RData when online,
# then reload RData when offline:
MPAs=load_MPAs()
EEZs=load_EEZs()
save(list=c('MPAs','EEZs'), file = file.path(tempdir(), "CCAMLRLayers.RData"))
rm(MPAs,EEZs)
load(file.path(tempdir(), "CCAMLRLayers.RData"))

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}}, \code{\link{load_Coastline}},
\code{\link{load_MPAs}}.
}
