% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R
\name{add_labels}
\alias{add_labels}
\title{Add labels}
\usage{
add_labels(
  mode = NULL,
  layer = NULL,
  fontsize = 1,
  fonttype = 1,
  angle = 0,
  col = "black",
  LabelTable = NULL
)
}
\arguments{
\item{mode}{either \code{'auto'}, \code{'manual'} or \code{'input'}. See Description above.}

\item{layer}{in \code{'auto'} mode, single or vector of characters, may only be one, some or all of: 
\code{c("ASDs","SSRUs","RBs","SSMUs","MAs","RefAreas","MPAs","EEZs")}.}

\item{fontsize}{in \code{'auto'} mode, size of the text.}

\item{fonttype}{in \code{'auto'} mode, type of the text (1 to 4), where 1 corresponds to plain text, 
2 to bold face, 3 to italic and 4 to bold italic.}

\item{angle}{in \code{'auto'} mode, rotation of the text in degrees.}

\item{col}{in \code{'auto'} mode, color of the text.}

\item{LabelTable}{in \code{'input'} mode, a label table that was generated in \code{'manual'} mode.}
}
\value{
Adds labels to plot. To save a label table generated in \code{'manual'} mode, use:
\code{MyLabelTable=add_labels(mode='auto')}. To re-use that label table, use: 
\code{add_labels(mode='input',LabelTable=MyLabelTable)}.
}
\description{
Adds labels to plots. Three modes are available:
In \code{'auto'} mode, labels are placed at the centres of polygon parts of spatial objects
loaded via the \code{load_} functions. Internally used in conjunction with \code{\link{Labels}}.
In \code{'manual'} mode, users may click on their plot to position labels. An editable label table is generated
to allow fine-tuning of labels appearance, and may be saved for external use. To edit the label table,
double-click inside one of its cells, edit the value, then close the table.
In \code{'input'} mode, a label table that was generated in \code{'manual'} mode is re-used.
}
\examples{
\donttest{

#Example 1: 'auto' mode
#label ASDs in bold and red
ASDs=load_ASDs()
plot(ASDs)
add_labels(mode='auto',layer='ASDs',fontsize=1,fonttype=2,col='red')
#add MPAs and EEZs and their labels in large, green and vertical text
MPAs=load_MPAs()
EEZs=load_EEZs()
plot(MPAs,add=TRUE,border='green')
plot(EEZs,add=TRUE,border='green')
add_labels(mode='auto',layer=c('EEZs','MPAs'),fontsize=2,col='green',angle=90)


#Example 2: 'manual' mode (you will have to do it yourself)
#Examples 2 and 3 below are commented (remove the # to test)
#plot(SmallBathy)
#ASDs=load_ASDs()
#plot(ASDs,add=TRUE)
#MyLabels=add_labels(mode='manual')


#Example 3: Re-use the label table generated in Example 2
#plot(SmallBathy)
#plot(ASDs,add=TRUE)
#add_labels(mode='input',LabelTable=MyLabels)



}

}
\seealso{


\code{\link{Labels}}, \code{\link{load_ASDs}}, \code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}}, \code{\link{load_EEZs}},
\code{\link{load_MPAs}},
\href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{R colors}.
}
