% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_depths.R
\name{get_depths}
\alias{get_depths}
\title{Get depths of locations from a bathymetry raster}
\usage{
get_depths(Input, Bathy, NamesIn = NULL)
}
\arguments{
\item{Input}{dataframe with, at least, Latitudes and Longitudes.
If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:

Latitude, Longitude, Variable 1, Variable 2, ... Variable x.}

\item{Bathy}{bathymetry raster with the appropriate \code{\link[CCAMLRGIS:CCAMLRp]{projection}},
such as \code{\link[CCAMLRGIS:SmallBathy]{this one}}. It is highly recommended to use a raster of higher
resolution than \code{\link{SmallBathy}} (see \code{\link{load_Bathy}}).}

\item{NamesIn}{character vector of length 2 specifying the column names of Latitude and Longitude fields in
the \code{Input}. Latitudes name must be given first, e.g.:

\code{NamesIn=c('MyLatitudes','MyLongitudes')}.}
}
\value{
dataframe with the same structure as the \code{Input} with an additional depth column \code{'d'}.
}
\description{
Given a bathymetry raster and an input dataframe of point locations (given in decimal degrees),
computes the depths at these locations (values for the cell each point falls in). The accuracy is
dependent on the resolution of the bathymetry raster (see \code{\link{load_Bathy}} to get high resolution data).
}
\examples{


#Generate a dataframe
MyData=data.frame(Lat=PointData$Lat,
Lon=PointData$Lon,
Catch=PointData$Catch)

#get depths of locations
MyDataD=get_depths(Input=MyData,Bathy=SmallBathy)
#View(MyDataD)
plot(MyDataD$d,MyDataD$Catch,xlab='Depth',ylab='Catch',pch=21,bg='blue')



}
\seealso{
\code{\link{load_Bathy}}, \code{\link{create_Points}},
 \code{\link{create_Stations}}, \code{\link{get_iso_polys}}.
}
