% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{retrieve_station_data}
\alias{retrieve_station_data}
\title{Query observation data}
\usage{
retrieve_station_data(stations, sensor_num, dur_code, start_date,
  end_date = "")
}
\arguments{
\item{stations}{three letter identification for CDEC location.}

\item{sensor_num}{sensor number for the measure of interest.}

\item{dur_code}{duration code for measure interval, "E", "H", "D", which correspong to Event, Hourly and Daily.}

\item{start_date}{date to start the query on.}

\item{end_date}{a date to end query on, defaults to current date.}
}
\value{
tidy dataframe
}
\description{
Function queries the CDEC services to obtain desired station data
based on station, sensor number, duration code and start/end date.
}
\examples{
kwk_hourly_flows <- CDECRetrieve::retrieve_station_data("KWK", "20", "H", "2017-01-01")

}
