% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-functions.R
\name{dateadd}
\alias{dateadd}
\title{Add days or years to a date in a dplyr query}
\usage{
dateadd(date, number, interval = "day")
}
\arguments{
\item{date}{The name of a date column in the database table as a character string}

\item{number}{The number of units to add. Can be a positive or negative whole number.}

\item{interval}{The units to add. Must be either "day" (default) or "year"}
}
\value{
Platform specific SQL that can be used in a dplyr query.
}
\description{
This function must be "unquoted" using the "bang bang" operator (!!). See example.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb())
date_tbl <- dplyr::copy_to(con, data.frame(date1 = as.Date("1999-01-01")),
                           name = "tmpdate", overwrite = TRUE, temporary = TRUE)

df <- date_tbl \%>\%
  dplyr::mutate(date2 = !!dateadd("date1", 1, interval = "year")) \%>\%
  dplyr::collect()

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
