% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateadd.R
\name{asDate}
\alias{asDate}
\alias{as_date}
\title{as.Date dbplyr translation wrapper}
\usage{
asDate(x)

as_date(x)
}
\arguments{
\item{x}{an R expression}
}
\description{
This is a workaround for using as.Date inside dplyr verbs against a database
backend. This function should only be used inside dplyr verbs where the first
argument is a database table reference. \code{asDate} must be unquoted with !! inside
dplyr verbs (see example).
}
\examples{
\dontrun{
con <- DBI::dbConnect(odbc::odbc(), "Oracle")
date_tbl <- dplyr::copy_to(con,
                           data.frame(y = 2000L, m = 10L, d = 10L),
                           name = "tmp",
                           temporary = TRUE)

df <- date_tbl \%>\%
  dplyr::mutate(date_from_parts = !!asDate(paste0(
    .data$y, "/",
    .data$m, "/",
    .data$d
  ))) \%>\%
  dplyr::collect()
}
}
