% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDVineCopulaConditional.r
\docType{data}
\name{dataset}
\alias{dataset}
\title{Random dataset from a given vine copula model}
\format{\describe{
  \item{\code{$data}}{An \code{1000 x 5} data set (format \code{data.frame}) with the uniform 
  variables \code{(U1,U2,U3,U4,U5)}.}
  \item{\code{$vine}}{\code{\link[VineCopula]{RVineMatrix}} object defyining the vine copula model from where \code{$data} was sampled.}
}}
\usage{
dataset
}
\description{
A random dataset simulated from a given 5-dimensional vine copula model.
}
\examples{

# Load data
data(dataset)

# Extract data
data <- dataset$data 
plot(data)

# Extract the RVineMatrix object from where the dataset was randomly sampled
vine <- dataset$vine
vine$Matrix 
vine$family
vine$par
vine$par2 
summary(vine)



}
\author{
Emanuele Bevacqua
}
\keyword{datasets}

