% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{delete_end_user}
\alias{delete_end_user}
\title{Delete a CEDARS End USer}
\usage{
delete_end_user(uri_fun, user, password, host, port, database, end_user)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{end_user}{CEDARS end user name.}
}
\value{
{
Confirmation that requested operation was completed, or error message if attempt failed.
}
}
\description{
Deletes one end user and associated password.
}
\examples{
\dontrun{
delete_end_user(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT', end_user = 'Mike')
}
}
