% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{start_local}
\alias{start_local}
\title{Start CEDARS Locally}
\usage{
start_local(user, password, host, port, database)
}
\arguments{
\item{user}{DB user name.}

\item{password}{DB password.}

\item{host}{Host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}
}
\value{
{
Launches the CEDARS Shiny app locally (on the desktop computer).
}
}
\description{
Starts CEDARS locally from RStudio. This is a functional approach and is easier to implement than a full-fledged Shiny Server. Multiple users can access the same CEDARS project on the MongoDB server using separate local R sessions, however in that case MongoDB credentials would have to be shared to all. The best option for multi-user implementations is to use Shiny Server.
}
\examples{
\dontrun{
start_local(user = 'John', password = 'db_password_1234', host = 'server1234', port = NA,
database = 'myDB')
}
}
