% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericDistances.R
\name{distanceNumericHamming}
\alias{distanceNumericHamming}
\title{Hamming Distance for Vectors}
\usage{
distanceNumericHamming(x, y)
}
\arguments{
\item{x}{first vector}

\item{y}{second vector}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1
}
\description{
The number of unequal elements of two vectors (which may be of unequal length), divided by the number of elements (of the larger vector).
}
\examples{
#e.g., used for distance between bit strings
x <- c(0,1,0,1,0)
y <- c(1,1,0,0,1)
distanceNumericHamming(x,y)
p <- replicate(10,sample(c(0,1),5,replace=TRUE),simplify=FALSE)
distanceMatrix(p,distanceNumericHamming)

}
