% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isDefinite.R
\name{is.NSD}
\alias{is.NSD}
\title{Check for Negative Semi-Definiteness}
\usage{
is.NSD(X, tol = 1e-08)
}
\arguments{
\item{X}{a symmetric matrix}

\item{tol}{torelance value. Eigenvalues between \code{-tol} and \code{tol} are assumed to be zero.

Symmetric, NSD matrices are, e.g., correlation
or kernel matrices. Such matrices are used in models like Kriging or Support Vector regression.}
}
\value{
boolean, which is TRUE if X is NSD
}
\description{
This function checks whether a symmetric matrix is Negative Semi-Definite (NSD).
That means, it is determined whether all eigenvalues of the matrix are non-positive.
Note that this function does not check whether the matrix is actually symmetric.
}
\examples{
# The following permutations will produce
# a non-PSD kernel matrix with Insert distance
# and a PSD distance matrix with Hamming distance
# (for the given theta value of 0.01)-
# The respective negative should be (non-) NSD
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
K <- exp(-0.01*distanceMatrix(x,distancePermutationInsert))
is.NSD(-K) 
K <- exp(-0.01*distanceMatrix(x,distancePermutationHamming))
is.NSD(-K)
}
\seealso{
\code{\link{is.CNSD}}, \code{\link{is.PSD}}
}
