% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enfa-class.R
\docType{class}
\name{enfa-class}
\alias{enfa-class}
\title{enfa-class}
\description{
An object of class \code{enfa} is created from performing ecological-niche
factor analysis on species presence data using the \code{enfa} function.
}
\section{Slots}{

\describe{
\item{\code{call}}{Original function call}

\item{\code{mf}}{numeric. Named vector representing the marginality factor, describing
the location of the species niche relative to the global niche}

\item{\code{marginality}}{numeric. Magnitude of the marginality factor \code{mf},
scaled by the global covariance matrix}

\item{\code{sf}}{numeric. Named vector representing the specialization factor,
equivalent to the eigenvalues of specialization}

\item{\code{specialization}}{numeric. The square root of the sum of eigenvalues, divided
by the length of \code{sf}}

\item{\code{p.spec}}{numeric. Named vector representing the proportion of
specialization found on each factor}

\item{\code{co}}{p x p matrix of standardized variable loadings}

\item{\code{cov}}{p x p species covariance matrix}

\item{\code{ras}}{RasterBrick of transformed climate values, with p layers}

\item{\code{weights}}{Raster layer of weights used for ENFA calculation}
}}

