% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{CFtime}
\alias{CFtime}
\title{Create a CFtime object}
\usage{
CFtime(definition, calendar = "standard", offsets = NULL)
}
\arguments{
\item{definition}{character. An atomic string describing the time coordinate
of a CF-compliant data file.}

\item{calendar}{character. An atomic string describing the calendar to use
with the time dimension definition string. Default value is "standard".}

\item{offsets}{numeric. An optional vector of offsets from the origin in the time
series. The unit of measure of the offsets is defined by the time series
definition as well.}
}
\value{
An object of the \code{CFtime} class.
}
\description{
This function creates an instance of the \code{CFtime} class. The parameters to
the call are typically read from a CF-compliant data file with climatological
observations or cliate change projections.
}
\examples{
CFtime("days since 1850-01-01", "julian", 0:364)
}
