% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{+,CFtime,numeric-method}
\alias{+,CFtime,numeric-method}
\title{Extend a CFtime object with additional offsets}
\usage{
\S4method{+}{CFtime,numeric}(e1, e2)
}
\arguments{
\item{e1}{CFtime. Instance of the \code{CFtime} class.}

\item{e2}{numeric. Vector of offsets to be added to the \code{CFtime} instance.}
}
\value{
A \code{CFtime} object with offsets composed of the \code{CFtime} instance and
the numeric vector.
}
\description{
A \code{CFtime} instance can be extended by adding additional offsets using this
operator.
}
\details{
The resulting \code{CFtime} instance will have its offsets in the order that they
are added, meaning that the offsets from the \code{CFtime} instance come first and
those from the numeric vector follow. There is no reordering or removal of
duplicates. This is because the time series are usually associated with a
data set and the correspondence between the two is thus preserved, if and
only if the data sets are merged in the same order.

Note that when adding multiple vectors of offsets to a \code{CFtime} instance, it
is more efficient to first concatenate the vectors and then do a final
addition to the \code{CFtime} instance. So avoid \code{CFtime(definition, calendar, e1) + CFtime(definition, calendar, e2) + CFtime(definition, calendar, e3) + ...}
but rather do \code{CFtime(definition, calendar, e1) + c(e2, e3, ...)}. It is the
responsibility of the operator to ensure that the offsets of the different
data sets are in reference to the same datum.

Negative offsets will generate an error.
}
\examples{
e1 <- CFtime("days since 1850-01-01", "gregorian", 0:364)
e2 <- 365:729
e1 + e2
}
