% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_gneglogpost.R
\name{CGGP_internal_gneglogpost}
\alias{CGGP_internal_gneglogpost}
\title{Gradient of negative log likelihood posterior}
\usage{
CGGP_internal_gneglogpost(
  theta,
  CGGP,
  y,
  ...,
  return_lik = FALSE,
  ys = NULL,
  Xs = NULL,
  HandlingSuppData = "Correct"
)
}
\arguments{
\item{theta}{Log of correlation parameters}

\item{CGGP}{CGGP object}

\item{y}{CGGP$design measured values}

\item{...}{Forces you to name remaining arguments}

\item{return_lik}{If yes, it returns a list with lik and glik}

\item{ys}{Supplementary output data}

\item{Xs}{Supplementary input data}

\item{HandlingSuppData}{How should supplementary data be handled?
* Correct: full likelihood with grid and supplemental data
* Only: only use supplemental data
* Ignore: ignore supplemental data}
}
\value{
Vector for gradient of likelihood w.r.t. x (theta)
}
\description{
Gradient of negative log likelihood posterior
}
\examples{
cg <- CGGPcreate(d=3, batchsize=20)
Y <- apply(cg$design, 1, function(x){x[1]+x[2]^2})
cg <- CGGPfit(cg, Y)
CGGP_internal_gneglogpost(cg$thetaMAP, CGGP=cg, y=cg$y)
}
