% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_append_fs.R
\name{CGGPappend}
\alias{CGGPappend}
\title{Add points to CGGP}
\usage{
CGGPappend(CGGP, batchsize, selectionmethod = "MAP")
}
\arguments{
\item{CGGP}{Sparse grid object}

\item{batchsize}{Number of points to add}

\item{selectionmethod}{How points will be selected: one of `UCB`, `TS`,
`MAP`, `Oldest`, `Random`, or `Lowest`.
`UCB` uses Upper Confidence Bound estimates for the parameters.
`TS` uses Thompson sampling, a random sample from the posterior.
`MAP` uses maximum a posteriori parameter estimates.
`Oldest` adds the block that has been available the longest.
`Random` adds a random block.
`Lowest` adds the block with the lowest sum of index levels.
`UCB` and `TS` are based on bandit algorithms and account for uncertainty
in the parameter estimates, but are the slowest.
`MAP` is fast but doesn't account for parameter uncertainty.
The other three are naive methods that are not adaptive and won't
perform well.}
}
\value{
SG with new points added.
}
\description{
Add `batchsize` points to `SG` using `theta`.
}
\examples{
SG <- CGGPcreate(d=3, batchsize=100)
y <- apply(SG$design, 1, function(x){x[1]+x[2]^2})
SG <- CGGPfit(SG, Y=y)
SG <- CGGPappend(CGGP=SG, batchsize=20, selectionmethod="MAP")
}
\seealso{
Other CGGP core functions: 
\code{\link{CGGPcreate}()},
\code{\link{CGGPfit}()},
\code{\link{predict.CGGP}()}
}
\concept{CGGP core functions}
