% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dset.R
\name{dset}
\alias{dset}
\title{Permutation-methods summary statistics}
\usage{
dset(group1, group2, nmc = 10000, returnData = FALSE)
}
\arguments{
\item{group1}{Vector of numeric values for first group.}

\item{group2}{Vector of numeric values for second group.}

\item{nmc}{Threshold for whether to use Monte Carlo draws or complete
enumeration. If the number of all possible combinations
\code{choose(n1+n2, n1) <= nmc}, we use complete enumeration.
Otherwise, we take a Monte Carlo sample of \code{nmc} permutations.
You can set \code{nmc = 0} to force complete enumeration regardless of
how many combinations there are.}

\item{returnData}{Whether the returned dataframe should include columns for
the permuted data itself (if TRUE), or only the derived columns that are
needed for confidence intervals and p-values (if FALSE, default).}
}
\value{
A data frame ready to be used in \code{cint()} or \code{pval()}.
}
\description{
Calculate table of differences in means, medians, etc. for each
combination (or permutation, if using Monte Carlo approx.),
as needed in order to compute a confidence interval using \code{\link{cint}}
and/or a p-value using \code{\link{pval}}.
}
\examples{
x <- c(19, 22, 25, 26)
y <- c(23, 33, 40)
demo <- dset(x, y, returnData = TRUE)
knitr::kable(demo, digits = 2)
}
