% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.r
\name{VarCorr}
\alias{VarCorr}
\alias{VarCorr.clme}
\alias{VarCorr.summary.clme}
\title{Variance components}
\usage{
VarCorr(object, ...)

\method{VarCorr}{summary.clme}(object, ...)

\method{VarCorr}{clme}(object, ...)
}
\arguments{
\item{object}{object from which to extract variance components}

\item{...}{space for additional arguments.}
}
\value{
Numeric.
}
\description{
Variance components

Variance components

Extracts variance components for objects of class \code{clme}.
}
\examples{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood ,
                 constraints = cons, seed = 42, nsim = 0)

VarCorr( clme.out )
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}

