% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_clv_data.R, R/f_s3generics_clvdata.R
\docType{class}
\name{clv.data-class}
\alias{clv.data-class}
\alias{show,clv.data-method}
\title{Transactional data to fit CLV models}
\usage{
\S4method{show}{clv.data}(object)
}
\description{
Stores the processed transactional data and holds an object of class \code{\link[CLVTools:clv.time-class]{clv.time}}
which stores further information about the split in an estimation and holdout sample.

A \code{clv.data} object serves as input into the various model fitting functions.
}
\section{Slots}{

\describe{
\item{\code{call}}{Single language of the call used to create the object}

\item{\code{name}}{Human-readable name of the type of transactional data}

\item{\code{clv.time}}{clv.time object that stores and is used for processing all timepoint related information}

\item{\code{data.transactions}}{Single \code{data.table} containing the original transaction data, with columns renamed to 'Id', 'Date', 'Price'}

\item{\code{data.repeat.trans}}{Single \code{data.table} containing only the repeat transactions}

\item{\code{has.spending}}{Single logical whether the data contains information about the amount spent per transaction}

\item{\code{has.holdout}}{Single logical whether the data is split in a holdout and estimation period}
}}

\seealso{
\code{\link[CLVTools:clv.time-class]{clv.time}}
}
\keyword{internal}
