% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_lemonade_sugar.R
\docType{data}
\name{lemonade_sugar}
\alias{lemonade_sugar}
\title{Lemonade Sugar data}
\format{
A data frame with 50 rows and three columns.
\describe{
\item{ranks}{the rank each lemonade based on sugar content}
\item{sugar_content}{type of lemonade ordered by sugar content}
\item{judge}{the judge providing the ranking}
}
}
\usage{
data(lemonade_sugar)
}
\description{
Five lemonades with increasing sugar content are ranked by each of ten
judges. They were not permitted to give tied outcomes. This is a randomised
block design.
}
\examples{
attach(lemonade_sugar)
gen_cor(x = ranks, y = sugar_content, U = 3, V = 3, rounding = 3)
}
\references{
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
\keyword{RBD}
\keyword{datasets}
\keyword{lemonade_sugar}
