% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_poles.R
\name{network_cof_hv_lv_poles}
\alias{network_cof_hv_lv_poles}
\title{Network cost of Failure for LV/HV Poles}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
network_cof_hv_lv_poles(
  pole_asset_category,
  no_customers,
  kva_per_customer = "Default"
)
}
\arguments{
\item{pole_asset_category}{String The type of Pole}

\item{no_customers}{Numeric. The numner of customers
fed by an individual asset.}

\item{kva_per_customer}{Numeric. If the asset have an exceptionally high
demand per customer type in kVA per customer. A setting of \code{"Default"}
results in a multiplication factor of 1 (cf. table 18, page 86, CNAIM, 2017).}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for Poles
(cf. section 7.6, page 83, CNAIM, 2017). Network cost of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
network_cof_hv_lv_poles(pole_asset_category = "20kV Poles",
no_customers = 750, kva_per_customer = 51)
}
