% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_transformer_11_20kv.R
\name{pof_future_transformer_11_20kv}
\alias{pof_future_transformer_11_20kv}
\title{Future Probability of Failure for 6.6/11kV and 20kV Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
pof_future_transformer_11_20kv(
  hv_transformer_type = "6.6/11kV Transformer (GM)",
  utilisation_pct = "Default",
  placement = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age,
  partial_discharge = "Default",
  oil_acidity = "Default",
  temperature_reading = "Default",
  observed_condition = "Default",
  reliability_factor = "Default",
  simulation_end_year = 100
)
}
\arguments{
\item{hv_transformer_type}{String. Refers to the high voltage transformer
type the calculation is done for. Options: \code{hv_transformer_type =
c("6.6/11kV Transformer (GM)", "20kV Transformer (GM)")}. The default setting
is \code{hv_transformer_type = 6.6/11kV Transformer (GM)}.}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{placement}{String. Specify if the asset is located outdoor or indoor.
A setting of \code{"Outdoor"} means the asset is
located in an outside environment,
and a setting of \code{"Indoor"} means the asset is located in an
 indoor environment. A setting of \code{"Default"} will result
  in either an indoor or an outdoor environment setting that depends
  on the specification of \code{asset_type}. See page 107-108,
  table 25A in CNAIM (2017) for default environments.}

\item{altitude_m}{Numeric. Specify the altitude location for
the asset measured in meters from sea level.\code{altitude_m}
is used to derive the altitude factor. See page 107,
table 23 in CNAIM (2017). A setting of \code{"Default"}
will set the altitude factor to 1 independent of \code{asset_type}.}

\item{distance_from_coast_km}{Numeric. Specify the distance from the
coast measured in kilometers. \code{distance_from_coast_km} is used
to derive the distance from coast factor See page 106,
table 22 in CNAIM (2017). A setting of \code{"Default"} will set the
 distance from coast factor to 1 independent of \code{asset_type}.}

\item{corrosion_category_index}{Integer.
Specify the corrosion index category, 1-5.
\code{corrosion_category_index} is used to derive the corrosion
category factor. See page 107, table 24 in CNAIM (2017).
A setting of \code{"Default"} will set the corrosion category factor
to 1 independent of \code{asset_type}.}

\item{age}{Numeric. The current age in years.}

\item{partial_discharge}{String. Indicating the
level of partial discharge. Options for \code{partial_discharge}:
\code{partial_discharge = c("Low", "Medium", "High (Not Confirmed)",
 "High (Confirmed)", "Default")}. See page 138, table 159 in CNAIM (2017).}

\item{oil_acidity}{Numeric. Measured in mg KOH/g.
See page 138, table 160 in CNAIM (2017).}

\item{temperature_reading}{String. Indicating the criticality.
Options for \code{temperature_reading}:
\code{temperature_reading = c("Normal", "Moderately High",
"Very High", "Default")}. See page 139, table 161 in CNAIM (2017).}

\item{observed_condition}{String. Indicating the observed condition of the
 transformer. Options for \code{observed_condition}:
\code{observed_condition = c("As New", "Good", "Slight Deterioration",
 "Poor", "Very Poor", "Default")}. See page 120, table 73 in CNAIM (2017).}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 69 in CNAIM (2017).}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
Numeric array. Future probability of failure.
}
\description{
This function calculates the future
annual probability of failure for 6.6/11kV and 20kV transformers.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 30 in CNAIM (2017).
}
\examples{
# Future probability of a 6.6/11 kV transformer
future_pof_transformer <-
pof_future_transformer_11_20kv(hv_transformer_type = "6.6/11kV Transformer (GM)",
utilisation_pct = "Default",
placement = "Default",
altitude_m = "Default",
distance_from_coast_km = "Default",
corrosion_category_index = "Default",
age = 20,
partial_discharge = "Default",
oil_acidity = "Default",
temperature_reading = "Default",
observed_condition = "Default",
reliability_factor = "Default",
simulation_end_year = 100)
plot(future_pof_transformer$PoF * 100,
type = "line", ylab = "\%", xlab = "years",
main = "PoF")
}
