% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_model.R
\name{predict_weibull_model}
\alias{predict_weibull_model}
\title{Prediction function for Weibull model}
\source{
\url{https://www.cnaim.io/docs/fault-analysis/}
}
\usage{
predict_weibull_model(
  age,
  environmental_factors = data.frame(utilisation_pct = "Default", placement = "Default",
    altitude_m = "Default", distance_from_coast_km = "Default", corrosion_category_index
    = "Default", partial_discharge = "Default", oil_acidity = "Default",
    temperature_reading = "Default", observed_condition = "Default"),
  weibull_model_parameters = data.frame(shapes = c(3.597272, 2.528015, 2.273607, 2.10145,
    2.048909), scales.intercept = c(100.17922, 45.54622, 73.63507, 29.99655, 31.19306),
    scales.1 = c(0.0028536801, 0.0014449054, 0.0011716558, -0.0003356626, -0.0017302242),
    scales.2 = c(-8.202209, -3.856043, -2.818854, -2.388243, -2.940468), scales.3 =
    c(-0.003023546, -0.001602048, -0.00134834, -0.00198866, -0.003149921), scales.4 =
    c(-0.040016081, -0.028129483, -0.017586604, -0.009426902, -0.02178312), scales.5 =
    c(-1.4776137, -0.6794045, 
     -0.6000869, -0.3839049, -0.4445468), scales.6 =
    c(-0.811395564, 0.015705206, -9.815935489, -0.002548827, -0.085903822), scales.7 =
    c(-4.4776511, -0.3677058, 0.4590218, -0.6364809, -0.3314029), scales.8 =
    c(-1.5861982, 0, -0.1398528, -0.1721091, 0), scales.9 = c(-0.7914404, -0.2632199,
    -1.1882148, 0, 0))
)
}
\arguments{
\item{age}{Numeric. Age of transformer which should be used in the prediction.}

\item{environmental_factors}{Data frame. Must contain the following fields:
utilisation_pct: Numeric or "Default",
placement: "Indoor", "Outdoor" or "Default",
altitude_m: Numeric or "Default",
distance_from_coast_km: Numeric or "Default",
corrosion_category_index: Numeric or "Default",
partial_discharge: "Low", "Medium", "High (Not Confirmed)", "High (Confirmed)" or "Default",
oil_acidity: Numeric or "Default",
temperature_reading: "Normal", "Moderately High", "Very High" or "Default",
observed_condition: "No deterioration", "Superficial/minor deterioration", "Slight Deterioration", "Some deterioration", "Substantial deterioration" or "Default"
Default value if environmental_factors is not provided: data frame with value "Default" for all fields}

\item{weibull_model_parameters}{Data frame. The output returned by the function
\code{\link{train_weibull_model}}().
Default value if weibull_parameters is not provided: data frame with parameters trained on data set transformer_11kv_faults.rda}
}
\value{
Numeric. Probability of failure at the given age.
}
\description{
This function uses the Weibull model parameters trained by the function \code{\link{train_weibull_model}}(), together
with the environmental factors for a specific transformer, and determines the probability of failure at a given age.
}
\examples{
predict_weibull_model(age = 50)

}
