% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_aggregate.R
\name{outrankMatrix}
\alias{outrankMatrix}
\title{Outranking matrix}
\usage{
outrankMatrix(ind_data, w = NULL)
}
\arguments{
\item{ind_data}{A data frame or matrix of indicator data, with observations as rows and indicators
as columns. No other columns should be present (e.g. label columns).}

\item{w}{A vector of weights, which should have length equal to \code{ncol(ind_data)}. Weights are relative
and will be re-scaled to sum to 1. If \code{w} is not specified, defaults to equal weights.}
}
\value{
An outranking matrix with \verb{nrow(ind_data} rows and columns (matrix class).
}
\description{
Constructs an outranking matrix based on a data frame of indicator data and corresponding weights. This function is used inside
\code{\link[=aggregate]{aggregate()}}.
}
\examples{
# get a sample of a few indicators
ind_data <- COINr::ASEMIndData[12:16]
# calculate outranking matrix
ORmatrix <- outrankMatrix(ind_data)
# check output
stopifnot(is.matrix(ORmatrix), nrow(ORmatrix) == nrow(ind_data))

}
