% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFtools.R
\name{rank_df}
\alias{rank_df}
\title{Convert a data frame to ranks}
\usage{
rank_df(df, use_group = NULL)
}
\arguments{
\item{df}{A data frame}

\item{use_group}{An optional column of df (specified as a string) to use as a grouping variable. If specified, returns ranks
inside each group present in this column.}
}
\value{
A data frame equal to the data frame that was input, but with any numerical columns replaced with ranks.
}
\description{
Replaces all numerical columns of a data frame with their ranks. Uses sport ranking, i.e. ties
share the highest rank place. Ignores non-numerical columns. See \code{\link[=rank]{rank()}}. Optionally, returns in-group ranks
using a specified grouping column.
}
\examples{
# some random data, with a column of characters
df <- data.frame(RName = c("A", "B", "C"),
Score1 = runif(3), Score2 = runif(3))
# convert to ranks
rank_df(df)
# grouped ranking - use some example data
df1 <- ASEM_iData[c("uCode", "GDP_group", "Goods", "LPI")]
rank_df(df1, use_group = "GDP_group")

}
