% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{synergySignificant}
\alias{synergySignificant}
\title{Function "synergySignificant" calculates significant synergy/antagonism concentration combinations and saves synergy/antagonism values.}
\usage{
synergySignificant(synergyCalculationLists, noOfRows, noOfCols, xDrug, yDrug,
  cellLine)
}
\arguments{
\item{synergyCalculationLists}{List of synergy/antagonism calculations.}

\item{noOfRows}{Number of rows in the experiment.}

\item{noOfCols}{Number of columns in the experiment.}

\item{xDrug}{Name of drug at x-axis.}

\item{yDrug}{Name of drug at y-axis.}

\item{cellLine}{Cell line or experiment name.}
}
\value{
Processed data.
}
\description{
Function "synergySignificant" calculates significant synergy/antagonism concentration combinations and saves synergy/antagonism values.
}
\examples{
dataFile <- system.file("/raw/rawDataPreProcessed.csv", package="COMBIA")
dataSample <- read.csv(dataFile, header=FALSE)
nR <- 8
nC <- 10
rslt <- applyBliss(nR, nC,  as.matrix(dataSample ), 100)
synergySignificant(rslt, nR, nC,"A", "B", "Cell")
}
\author{
Muhammad kashif
}

