% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get.fixed}
\alias{get.fixed}
\title{Construct an object that specifies which indices of coefficients should
remain fixed in maximum likelihood computation.}
\usage{
get.fixed(beta = integer(0), gamma = integer(0), zeta = integer(0))
}
\arguments{
\item{beta}{Vector of indices of \code{beta} to keep fixed.}

\item{gamma}{Vector of indices of \code{gamma} to keep fixed.}

\item{zeta}{Vector of indices of \code{zeta} to keep fixed.}
}
\value{
List of vectors indicating fixed indices.
}
\description{
Construct an object that specifies which indices of coefficients should
remain fixed in maximum likelihood computation.
}
\details{
Arguments are expected to be vectors of integers. These are interpreted as
the indices to keep fixed during optimization. For example,
\code{beta = c(1L, 1L, 2L)} indicates that the first and second elements of
\code{beta} should remain fixed. Note that duplicate indices are ignored.
The default value is the empty vector \code{integer(0)}, which requests that
no elements of the given coefficient vector should be fixed.
}
