% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONDOP.R
\name{get.operon.end.points}
\alias{get.operon.end.points}
\title{Determine operon end-points (OEPs).}
\usage{
get.operon.end.points(fwd.sh.decs, rev.sh.decs, genes.and.operons, igrs.p,
  igrs.n, transcCDSs, borders = c(10, 100), max.end.transc = c(0.1, 0.1),
  minExprCDS = 0.1, verbose = TRUE, ...)
}
\arguments{
\item{genes.and.operons}{Data table merging gene(s) and operon(s) annotations.}

\item{igrs.p}{Data table containing generic information of the intergenic regions on the forward strand. See \code{get.intergenic.regions}.}

\item{igrs.n}{Data table containing generic information of the intergenic regions on the reverse strand. See \code{get.intergenic.regions}.}

\item{transcCDSs}{Transcription levels for the coding regions. See \code{comp.gene.transc.levels}.}

\item{borders}{A numeric vector.}

\item{minExprCDS}{Minimum expression level for the coding sequence regions (CDSs). Default values is 0.1.}

\item{verbose}{}

\item{fwd.sh.incs}{Data table containing information on the sharp decreases in transcription found on the forward strand. See \code{detect.sid.points}.}

\item{rev.sh.incs}{Data table containing information on the sharp decreases in transcription found on the reverse strand. See \code{detect.sid.points}.}

\item{max.start.transc}{Maximum log2.}
}
\description{
Internal function to estimate the gene-level expression values using the RPKM method.
}
\author{
Vittorio Fortino
get.operon.start.points()
}
\keyword{internal}

