% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{cpt_consistent_var}
\alias{cpt_consistent_var}
\title{Variance Estimation Consistent Under Change}
\usage{
cpt_consistent_var(x, k)
}
\arguments{
\item{x}{A numeric vector for the data set}

\item{k}{The potential change point at which the data set is split}
}
\value{
The estimated change-consistent variance
}
\description{
Estimate the variance (using the sum of squared errors) with an estimator
that is consistent when the mean changes at a known point.
}
\details{
This is the estimator

\deqn{\hat{\sigma}^2_{T,t} = T^{-1}\left(\sum_{s = 1}^t \left(X_s -
      \bar{X}_t\right)^2 + \sum_{s = t + 1}^{T}\left(X_s - \tilde{X}_{T - t}
      \right)^2\right)}

where \eqn{\bar{X}_t = t^{-1}\sum_{s = 1}^t X_s} and \eqn{\tilde{X}_{T - t} =
(T - t)^{-1} \sum_{s = t + 1}^{T} X_s}. In this implementation, \eqn{T} is
computed automatically as \code{length(x)} and \code{k} corresponds to
\eqn{t}, a potential change point.
}
\examples{
CPAT:::cpt_consistent_var(c(rnorm(500, mean = 0), rnorm(500, mean = 1)), k = 500)
}
