% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindowSizeRecog.R
\name{WindowSizeRecog}
\alias{WindowSizeRecog}
\title{WindowSizeRecog is a function to specify window size for each order of COREs}
\usage{
WindowSizeRecog(InputData, COREorder, WScutoff)
}
\arguments{
\item{InputData}{The input data as a table including chromosome regions
in which the first column is chromosome annotation, and second and third
columns are start and ending positions.}

\item{COREorder}{Order of the COREs which window size has to be determined for.}

\item{WScutoff}{Threshold used to identify WS within distribution of maximum distance between peaks for each order of CORE}
}
\value{
Window size identified for each order of CORE
}
\description{
WindowSizeRecog is a function to specify window size for each order of COREs
}
\examples{
InputData <- read.table(system.file("extdata", "A549_Chr21.bed",
package = "CREAM"), sep="\\t")
colnames(InputData) <- c("chr", "start", "end")
MinLength <- 1000
if(nrow(InputData) < MinLength){
   stop(paste( "Number of functional regions is less than ", MinLength,
   ".", sep = "", collapse = ""))
}
peakNumMin <- 2
WScutoff <- 1.5
WindowSize <- WindowSizeRecog(InputData, peakNumMin, WScutoff)
}
