% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{specify_buffer}
\alias{specify_buffer}
\title{Specification of buffer zone in a cluster randomized trial}
\usage{
specify_buffer(trial, buffer_width = 0)
}
\arguments{
\item{trial}{an object of class \code{"CRTsp"} or a data frame containing locations in (x,y) coordinates, cluster
assignments (factor \code{cluster}), and arm assignments (factor \code{arm}).}

\item{buffer_width}{minimum distance between locations in
opposing arms for them to qualify to be included in the core area (km)}
}
\value{
A list of class \code{"CRTsp"} containing the following components:
\tabular{lll}{
\code{geom_full}   \tab list: \tab summary statistics describing the site,
cluster assignments, and randomization.\cr
\code{geom_core}   \tab list: \tab summary statistics describing the core area \cr
\code{trial} \tab data frame: \tab rows correspond to geolocated points, as follows:\cr
\tab \code{x} \tab numeric vector: x-coordinates of locations \cr
\tab \code{y} \tab numeric vector: y-coordinates of locations \cr
\tab \code{cluster} \tab factor: assignments to cluster of each location  \cr
\tab \code{arm} \tab factor: assignments to \code{"control"} or \code{"intervention"} for each location \cr
\tab \code{nearestDiscord} \tab numeric vector: signed Euclidean distance to nearest discordant location (km) \cr
\tab \code{buffer} \tab logical: indicator of whether the point is within the buffer \cr
\tab \code{...} \tab other objects included in the input \code{"CRTsp"} object or data frame \cr
}
}
\description{
\code{specify_buffer} specifies a buffer zone in a cluster randomized
trial (CRT) by flagging those locations that are within a defined distance of
those in the opposite arm.
}
\examples{
#Specify a buffer of 200m
exampletrial <- specify_buffer(trial = readdata('exampleCRT.txt'), buffer_width = 0.2)
}
