% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_SplitDim.R
\name{CST_SplitDim}
\alias{CST_SplitDim}
\title{Function to Split Dimension}
\usage{
CST_SplitDim(data, split_dim = "time", indices = NULL, freq = "monthly")
}
\arguments{
\item{data}{a 's2dv_cube' object}

\item{split_dim}{a character string indicating the name of the dimension to split}

\item{indices}{a vector of numeric indices or dates. If left at NULL, the dates provided in the s2dv_cube object (element Dates) will be used.}

\item{freq}{a character string indicating the frequency: by 'day', 'month' and 'year' or 'monthly' (by default). 'month' identifies months between 1 and 12 independently of the year they belong to, while 'monthly' differenciates months from different years.}
}
\description{
This function split a dimension in two. The user can select the dimension to split and provide indices indicating how to split that dimension or dates and the frequency expected (monthly or by day, month and year). The user can also provide a numeric frequency indicating the length of each division.
}
\examples{

data <- 1 : 20
dim(data) <- c(time = 10, lat = 2)
data <-list(data = data)
class(data) <- 's2dv_cube'
indices <- c(rep(1,5), rep(2,5))
new_data <- CST_SplitDim(data, indices = indices)
time <- c(seq(ISOdate(1903, 1, 1), ISOdate(1903, 1, 4), "days"),
         seq(ISOdate(1903, 2, 1), ISOdate(1903, 2, 4), "days"),
         seq(ISOdate(1904, 1, 1), ISOdate(1904, 1, 2), "days"))
data <- list(data = data$data, Dates = time)
class(data) <- 's2dv_cube'
new_data <- CST_SplitDim(data, indices = time)
dim(new_data$data)
new_data <- CST_SplitDim(data, indices = time, freq = 'day')
dim(new_data$data)
new_data <- CST_SplitDim(data, indices = time, freq = 'month')
dim(new_data$data)
new_data <- CST_SplitDim(data, indices = time, freq = 'year')
dim(new_data$data)
}
\author{
Nuria Perez-Zanon, \email{nuria.perez@bsc.es}
}

