% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPDFsOLE.R
\name{PlotPDFsOLE}
\alias{PlotPDFsOLE}
\title{Plotting two probability density gaussian functions and the optimal linear 
estimation (OLE) as result of combining them.}
\usage{
PlotPDFsOLE(
  pdf_1,
  pdf_2,
  nsigma = 3,
  legendPos = "bottom",
  legendSize = 1,
  plotfile = NULL,
  width = 30,
  height = 15,
  units = "cm",
  dpi = 300
)
}
\arguments{
\item{pdf_1}{A numeric array with a dimension named 'statistic', containg 
two parameters: mean' and 'standard deviation' of the first gaussian pdf 
to combining.}

\item{pdf_2}{A numeric array with a dimension named 'statistic', containg 
two parameters: mean' and 'standard deviation' of the second gaussian pdf 
to combining.}

\item{nsigma}{(optional) A numeric value for setting the limits of X axis. 
(Default nsigma = 3).}

\item{legendPos}{(optional) A character value for setting the position of the
legend ("bottom", "top", "right" or "left")(Default 'bottom').}

\item{legendSize}{(optional) A numeric value for setting the size of the 
legend text. (Default 1.0).}

\item{plotfile}{(optional) A filename where the plot will be saved. 
(Default: the plot is not saved).}

\item{width}{(optional) A numeric value indicating the plot width in 
units ("in", "cm", or "mm"). (Default width = 30).}

\item{height}{(optional) A numeric value indicating the plot height. 
(Default height = 15).}

\item{units}{(optional) A character value indicating the plot size 
unit. (Default units = 'cm').}

\item{dpi}{(optional) A numeric value indicating the plot resolution.
(Default dpi = 300).}
}
\value{
PlotPDFsOLE() returns a ggplot object containing the plot.
}
\description{
This function plots two probability density gaussian functions 
and the optimal linear estimation (OLE) as result of combining them.
}
\examples{
# Example 1
pdf_1 <- c(1.1,0.6)
attr(pdf_1, "name") <- "NAO1"
dim(pdf_1) <-  c(statistic = 2)
pdf_2 <- c(1,0.5)
attr(pdf_2, "name") <- "NAO2"
dim(pdf_2) <-  c(statistic = 2)

PlotPDFsOLE(pdf_1, pdf_2)
}
\author{
Eroteida Sanchez-Garcia - AEMET, //email{esanchezg@aemet.es}
}
