% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csuv_plot.r
\name{plot.csuv}
\alias{plot.csuv}
\title{Graphical illustration of selection uncertainty}
\usage{
\method{plot}{csuv}(
  x,
  with.unconditional = FALSE,
  compare.method.fit = NULL,
  cv.mod = NULL,
  with.thr = TRUE,
  with.violin = FALSE,
  to.shade = TRUE,
  ci.method = "conditional",
  level = 0.1,
  var.freq.thr = 0.1,
  log.level = NULL,
  ...
)
}
\arguments{
\item{x}{fitted results from CSUV::csuv()}

\item{with.unconditional}{TRUE to get a unconditonal boxplot on the same graph. Default is FALSE}

\item{compare.method.fit}{(optional) fitted results from CSUV::lm.compare.methods(). Alternatively, user can provide a data frame with each row contains the estimated coefficients from a method. The name of each row should be corresponding to the name of the method. The first value of each row should be the value of the intercept}

\item{cv.mod}{(optional) a vector of estimated coefficients from cross validation. The first value should be the value of the intercept}

\item{with.thr}{whether the selection by the CSUV should be show. Default is TRUE}

\item{with.violin}{whether the graph with violin plot}

\item{to.shade}{whether to shade the graph by the relative frequency calculated by CSUV. Default is TRUE}

\item{ci.method}{how the confidence interval should be calculated. Default is "conditional"}

\item{level}{the significant level of the whiskers. Default is 0.1}

\item{var.freq.thr}{minimum variable frequency to show, default is 0.1}

\item{log.level}{log level to set. Default is NULL, which means no change in log level. See the function CSUV::set.log.level for more details}

\item{...}{additional argument for plot}
}
\value{
a ggplot object
}
\description{
Graphical illustration of selection uncertainty
}
\examples{
\donttest{
X = matrix(rnorm(1000), nrow = 100)
Y = rowSums(X[,1:3])+rnorm(100)
mod.0 = csuv(X, Y, intercept = FALSE, q = 0, method.names = NULL)
cv.mod = lm.cv(X, Y, intercept = FALSE, fit.percent = 0.5, num.repeat = 50)
compare.mod = lm.compare.method(X, Y, intercept = FALSE)
plot(mod.0, compare.method.fit = compare.mod, cv.mod = cv.mod$est.b)
}
}
