% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.Miller2015.r
\docType{data}
\name{Miller2015}
\alias{Miller2015}
\title{Miller et al. (2015)}
\format{
Miller2015 - The data frame with 1203 metabolite features as rows,
and 186 untargeted metabolomics patient samples as columns, alongside 16
metabolite annotations. The first row also provides the biochemical
diagnosis confirmed for each patient sample.
}
\source{
Supporting Information: jimd1029-sup-0001.xls
(\href{https://tinyurl.com/yypsbghe}{Dataset})
}
\usage{
data(Miller2015)
}
\description{
Untargeted metabolomic analysis for the clinical screening of 
inborn errors of metabolism. Global metabolic profiling obtained by 
untargeted mass spectrometry-based metabolomic platform for the detection
of novel and known inborn errors of metabolism.  This untargeted approach 
collected z-score values for ~1200 unique compounds (including 
~500 named human analytes) from human plasma.  Data set contains 
186 individual plasma samples (118 confirmed inborn errors of
metabolism).  The outcome describes excellent sensitivity and 
specificity for the detection of a wide rage of metabolic disorders 
and identified novel biomarkers for some diseases.
}
\examples{
data(Miller2015)
}
\references{
Miller et al. (2015). Untargeted metabolomic analysis for the
clinical screening of inborn errors of metabolism. J Inherit Metab Dis,
38: 1029–1039. (\href{https://doi.org/10.1007/s10545-015-9843-7}{Article})
}
\keyword{datasets}
