% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.connectToExt.r
\name{graph.connectToExt}
\alias{graph.connectToExt}
\title{Connect a node to its unvisited "extended" neighbors}
\usage{
graph.connectToExt(adj_mat, startNode, visitedNodes)
}
\arguments{
\item{adj_mat}{- The adjacency matrix that encodes the edge weights 
for the network.}

\item{startNode}{- The node most recently visited by the network walker,
from which p1 gets dispersed.}

\item{visitedNodes}{- The history of previous draws in the node ranking
sequence.}
}
\value{
adj_matAfter - The adjacency matrix where the startNode is now
connected to its unvisited "extended" neighbors. An extended neighbor is
the neighbor of a neighbor.
}
\description{
Connect a node to its unvisited "extended" neighbors
}
\examples{
adj_mat = rbind(c(0,2,1,0,0,0,0), # A
                c(2,0,1,0,0,0,0), # B
                c(1,0,0,1,0,0,0), # C
                c(0,0,1,0,2,0,0), # D
                c(0,0,0,2,0,2,1), # E
                c(0,0,0,1,2,0,1), # F
                c(0,0,0,0,1,1,0)  # G
                )
rownames(adj_mat) = c("A", "B", "C", "D", "E", "F", "G")
colnames(adj_mat) = c("A", "B", "C", "D", "E", "F", "G")
ig = graph.adjacency(as.matrix(adj_mat), mode="undirected",weighted=TRUE)
G=vector(mode="list", length=7)
G[seq_len(length(G))] = 0
names(G) = c("A", "B", "C", "D", "E", "F", "G")
startNode = "A"
visitedNodes = c("B", "C")
coords = layout.fruchterman.reingold(ig)
V(ig)$x = coords[,1]
V(ig)$y = coords[,2]
adj_matAfter = graph.connectToExt(adj_mat, startNode, visitedNodes)
}
