% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericFunctions.R
\name{summary.ctp}
\alias{summary.ctp}
\alias{summary.ctp.str}
\alias{Display}
\alias{Display.ctp}
\alias{Display.ctp.str}
\title{Summarizing and plotting the results of hypothesis trees and closed testing procedures}
\usage{
\method{summary}{ctp}(object, digits = 4, ...)

\method{summary}{ctp.str}(object, ...)

Display(object, ...)

\method{Display}{ctp}(object, Type = "s", arrow = FALSE, ...)

\method{Display}{ctp.str}(object, Type = "s", arrow = FALSE, ...)
}
\arguments{
\item{object}{Object generated by \code{\link{AnalyseCTP}} or \code{\link{IntersectHypotheses}}.}

\item{digits}{The minimum number of significant digits to be printed for the p-values in the summary.}

\item{...}{Additional arguments passed to \code{Display}.}

\item{Type}{Type of the plotted tree: \code{"s"} straight lines, \code{""} tree type.}

\item{arrow}{If \code{TRUE}, an arrow is plotted in the connections.}
}
\value{
\itemize{
\item \code{summary.ctp.str} provides lists with dataframes comprising the hypothesis names as strings
     and the relationship between the hypotheses.
\item \code{summary.ctp} provides a table of hypotheses, raw p-values and 
    adjusted p-values. 
 }
}
\description{
The functions \code{summary.ctp.str} and \code{Display.ctp.str} summarise and plot the hypothesis tree of a closed testing procedure,
whereas the functions \code{summary.ctp} and \code{Display.ctp} summarise and plot the results of a closed testing procedure.
}
\details{
@name Generic_Functions
 
 @aliases summary Display
}
\note{
\code{Disply.ctp.str} plots the hypothesis tree. \cr \code{Display.ctp} plots the hypothesis 
    tree together with the unadjusted and adjusted p-values.
}
\seealso{
\code{\link{IntersectHypotheses}}, \code{\link{AnalyseCTP}}
}
