% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varmatCUB.R
\name{varmatCUB}
\alias{varmatCUB}
\title{Variance-covariance matrix for CUB models}
\usage{
varmatCUB(ordinal,m,param,Y=0,W=0,shelter=0)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{m}{Number of ordinal categories}

\item{param}{Vector of parameters for the specified CUB model}

\item{Y}{Matrix of selected covariates to explain the uncertainty component (default: no covariate is included 
in the model)}

\item{W}{Matrix of selected covariates to explain the feeling component (default: no covariate is included 
in the model)}

\item{shelter}{Category corresponding to the shelter choice (default: no shelter effect is included in the 
model)}
}
\description{
Compute the variance-covariance matrix of parameter estimates for CUB models with or without
covariates for the feeling and the overdispersion parameter, and for extended CUB models with shelter effect.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not, 
it returns a warning message and produces a matrix with NA entries.
}
\examples{
data(univer)
m<-7
### CUB model with no covariate
ordinal<-univer[,12]
pai<-0.87; csi<-0.17; 
param<-c(pai,csi)
varmat<-varmatCUB(ordinal,m,param)
#######################
### and With covariates for feeling
data(univer)
m<-7
ordinal<-univer[,9]
pai<-0.86; gama<-c(-1.94, -0.17);
param<-c(pai,gama)
W<-univer[,4]           
varmat<-varmatCUB(ordinal,m,param, W=W)
#######################
### CUB model with uncertainty covariates
data(relgoods)
m<-10
ordinal<-relgoods[,29]
gender<-relgoods[,2]
data<-na.omit(cbind(ordinal,gender))
ordinal<-data[,1]
Y<-data[,2]
bet<-c(-0.811,0.93); csi<-0.202;
varmat<-varmatCUB(ordinal,m,param=c(bet,csi),Y=Y)
#######################
### and with covariates for both parameters
data(relgoods)
m<-10
gender<-relgoods[,2]
smoking<-relgoods[,12]
ordinal<-relgoods[,40]
nona<-na.omit(cbind(ordinal,gender,smoking))
ordinal<-nona[,1]
gender<-nona[,2]
smoking<-nona[,3]
gama<-c(-0.55, -0.43); bet<-c(-0.45, -0.48);
varmat<-varmatCUB(ordinal,m,param=c(bet,gama),Y=gender,W=smoking)
#######################
### Variance-covariance for a CUB model with shelter
m<-8; n<-300;
pai1<-0.5; pai2<-0.3; csi<-0.4;
shelter<-6;
pr<-probcubshe1(m,pai1,pai2,csi,shelter)
ordinal<-sample(1:m,n,prob=pr,replace=TRUE)
param<-c(pai1,pai2,csi)
varmat<-varmatCUB(ordinal,m,param,shelter=shelter)
}
\references{
Piccolo D. (2006). Observed Information Matrix for MUB Models, 
\emph{Quaderni di Statistica}, \bold{8}, 33--78 \cr
Iannario, M. (2012). Modelling shelter choices in ordinal data surveys. 
\emph{Statistical Modelling and Applications}, \bold{21}, 1--22
}
\seealso{
\code{\link{CUB}}, \code{\link{loglikCUB}}
}
\keyword{htest}

