% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cubpq.R
\name{cubpq}
\alias{cubpq}
\title{Main function for CUB models with covariates for both the uncertainty and the feeling components}
\usage{
cubpq(m, ordinal, Y, W, maxiter, toler)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates for explaining the uncertainty component}

\item{W}{Matrix of selected covariates for explaining the feeling component}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}

\item{summary}{Logical: if TRUE, summary results of the fitting procedure are displayed on screen}
}
\value{
An object of the class "CUB"
}
\description{
Estimate and validate a CUB model for given ordinal responses, with covariates for explaining both the
 feeling and the uncertainty components by means of logistic transform.
}
\references{
Piccolo D. and D'Elia A. (2008), A new approach for modelling consumers' preferences, \emph{Food Quality and Preference},
\bold{18}, 247--259 \cr
Iannario M. and Piccolo D. (2010), A new statistical model for the analysis of customer satisfaction,
\emph{Quality Technology and Quantitative Management}, \bold{17}(2)  149--168
}
\seealso{
\code{\link{varcovcubpq}}, \code{\link{loglikcubpq}}, \code{\link{inibestgama}}, \code{\link{CUB}}
}
\keyword{internal}

