% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{parse_kernel_variable}
\alias{parse_kernel_variable}
\title{Create Kernel Matrix}
\usage{
parse_kernel_variable(kern_var_name, kern_func, data, data_new = NULL)
}
\arguments{
\item{kern_var_name}{(vector of characters) Names of variables in data to
create the kernel matrix from. Must be a single term that is either of the form
\eqn{x} (a single linear term) or \eqn{k(x1, x2, \dots)} (a kernel term that may
contain multiple variables).}

\item{kern_func}{(function) A kernel function. Will be overwritten to linear
kernel if the variable doesn't contain 'k()'.}

\item{data}{(data.frame, n*d) A data.frame, list or environment (or object
coercible by as.data.frame to a data.frame), containing the variables in
formula. Neither a matrix nor an array will be accepted.}

\item{data_new}{(data.frame, n_new*d) New data for computing predictions.}
}
\value{
\item{kernel_mat}{(matrix, n*n) The kernel matrix corresponding to 
the variable being computed.}
}
\description{
Create kernel matrix for each variable in the formula.
}
\author{
Jeremiah Zhe Liu
}
\keyword{internal}
