% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{AffineProd-class}
\alias{AffineProd-class}
\alias{.AffineProd}
\alias{AffineProd}
\alias{AffineProd}
\alias{validate_args,AffineProd-method}
\alias{to_numeric,AffineProd-method}
\alias{size_from_args,AffineProd-method}
\alias{sign_from_args,AffineProd-method}
\alias{is_atom_convex,AffineProd-method}
\alias{is_atom_concave,AffineProd-method}
\alias{is_incr,AffineProd-method}
\alias{is_decr,AffineProd-method}
\alias{is_quadratic,AffineProd-method}
\title{The AffineProd class.}
\usage{
AffineProd(x, y)

\S4method{validate_args}{AffineProd}(object)

\S4method{to_numeric}{AffineProd}(object, values)

\S4method{size_from_args}{AffineProd}(object)

\S4method{sign_from_args}{AffineProd}(object)

\S4method{is_atom_convex}{AffineProd}(object)

\S4method{is_atom_concave}{AffineProd}(object)

\S4method{is_incr}{AffineProd}(object, idx)

\S4method{is_decr}{AffineProd}(object, idx)

\S4method{is_quadratic}{AffineProd}(object)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric constant representing the left-hand value.}

\item{y}{An \linkS4class{Expression} or numeric constant representing the right-hand value.}

\item{object}{An \linkS4class{AffineProd} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}
}
\description{
This class represents the product of two affine expressions.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check dimensions of arguments and linearity.

\item \code{to_numeric}: The product of two affine expressions.

\item \code{size_from_args}: The size of the atom.

\item \code{sign_from_args}: Default to rules for times.

\item \code{is_atom_convex}: Affine times affine is not convex.

\item \code{is_atom_concave}: Affine times affine is not concave.

\item \code{is_incr}: A logical value indicating whether the atom is weakly increasing in \code{idx}.

\item \code{is_decr}: A logical value indicating whether the atom is weakly decreasing in \code{idx}.

\item \code{is_quadratic}: The affine product is always quadratic.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric constant representing the left-hand value.}

\item{\code{y}}{An \linkS4class{Expression} or numeric constant representing the right-hand value.}
}}

