% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/affine.R
\docType{methods}
\name{/,Expression,Expression-method}
\alias{/,Expression,Expression-method}
\alias{/,Expression,ConstVal-method}
\alias{/,ConstVal,Expression-method}
\alias{DivExpression-class}
\alias{DivExpression}
\alias{is_quadratic,DivExpression-method}
\alias{size_from_args,DivExpression-method}
\alias{is_incr,DivExpression-method}
\alias{is_decr,DivExpression-method}
\alias{graph_implementation,DivExpression-method}
\title{The DivExpression class.}
\usage{
\S4method{/}{Expression,Expression}(e1, e2)

\S4method{/}{Expression,ConstVal}(e1, e2)

\S4method{/}{ConstVal,Expression}(e1, e2)

\S4method{is_quadratic}{DivExpression}(object)

\S4method{size_from_args}{DivExpression}(object)

\S4method{is_incr}{DivExpression}(object, idx)

\S4method{is_decr}{DivExpression}(object, idx)

\S4method{graph_implementation}{DivExpression}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{e1, e2}{The \linkS4class{Expression} objects or numeric constants to divide. The denominator, \code{e2}, must be a scalar constant.}

\item{object}{A \linkS4class{DivExpression} object.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents one expression divided by another expression.
}
\section{Methods (by generic)}{
\itemize{
\item \code{is_quadratic}: Is the left-hand expression quadratic and the right-hand expression constant?

\item \code{size_from_args}: The size of the left-hand expression.

\item \code{is_incr}: Is the right-hand expression positive?

\item \code{is_decr}: Is the right-hand expression negative?

\item \code{graph_implementation}: The graph implementation of the expression.
}}

