% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{SigmaMax-class}
\alias{SigmaMax-class}
\alias{.SigmaMax}
\alias{SigmaMax}
\alias{to_numeric,SigmaMax-method}
\alias{allow_complex,SigmaMax-method}
\alias{dim_from_args,SigmaMax-method}
\alias{sign_from_args,SigmaMax-method}
\alias{is_atom_convex,SigmaMax-method}
\alias{is_atom_concave,SigmaMax-method}
\alias{is_incr,SigmaMax-method}
\alias{is_decr,SigmaMax-method}
\alias{.grad,SigmaMax-method}
\title{The SigmaMax class.}
\usage{
SigmaMax(A = A)

\S4method{to_numeric}{SigmaMax}(object, values)

\S4method{allow_complex}{SigmaMax}(object)

\S4method{dim_from_args}{SigmaMax}(object)

\S4method{sign_from_args}{SigmaMax}(object)

\S4method{is_atom_convex}{SigmaMax}(object)

\S4method{is_atom_concave}{SigmaMax}(object)

\S4method{is_incr}{SigmaMax}(object, idx)

\S4method{is_decr}{SigmaMax}(object, idx)

\S4method{.grad}{SigmaMax}(object, values)
}
\arguments{
\item{A}{An \linkS4class{Expression} or matrix.}

\item{object}{A \linkS4class{SigmaMax} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
The maximum singular value of a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(SigmaMax)}: The largest singular value of \code{A}.

\item \code{allow_complex(SigmaMax)}: Does the atom handle complex numbers?

\item \code{dim_from_args(SigmaMax)}: The atom is a scalar.

\item \code{sign_from_args(SigmaMax)}: The atom is positive.

\item \code{is_atom_convex(SigmaMax)}: The atom is convex.

\item \code{is_atom_concave(SigmaMax)}: The atom is concave.

\item \code{is_incr(SigmaMax)}: The atom is not monotonic in any argument.

\item \code{is_decr(SigmaMax)}: The atom is not monotonic in any argument.

\item \code{.grad(SigmaMax)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{A}}{An \linkS4class{Expression} or numeric matrix.}
}}

