% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.calibration_simplex.R
\name{plot.calibration_simplex}
\alias{plot.calibration_simplex}
\title{Plot Calibration Simplex}
\usage{
\method{plot}{calibration_simplex}(x, true_error = TRUE,
  error_scale = 0.3, min_bin_freq = 10, plot_error_scale = TRUE,
  scale_area = NULL, indicate_bins = TRUE, category_labels = c("1",
  "2", "3"), ...)
}
\arguments{
\item{x}{Object of class \code{calibration_simplex}}

\item{true_error}{Logical, specifying whether to use true miscalibration errors or approximate miscalibration errors.}

\item{error_scale}{A number specifying the magnitude of the miscalibration errors (greater 0, usually should be less than 1,
cf. note below).}

\item{min_bin_freq}{A number. Lower bound for (absolute) frequencies, i.e. how many observations have to lie in a bin
for it to be plotted.}

\item{plot_error_scale}{Logical, specifying whether to plot a scale showing the magnitude of miscalibration errors.}

\item{scale_area}{Optional. A number by which the areas of the points are scaled. Use if points are to small or to big.}

\item{indicate_bins}{Logical, specifying whether to connect points to their respective bin (center of hexagon).}

\item{category_labels}{A vector of length 3 containing the category names, e.g. \code{c("1","2","3")} (default)}

\item{...}{Arguments concerning the title (e.g. \code{main}, \code{cex.main}, \code{col.main} and \code{font.main})
and subtitle (e.g. \code{sub}, \code{cex.sub}, \code{col.sub} and \code{font.sub}) may be passed here.}
}
\description{
Plot Calibration Simplex
}
\note{
For details on the meaning of the error scale, cf. Wilks, 2013, especially Fig. 2. Note that the miscalibration error in
each category is in "probability units" (as it is the average difference in relative frequency and forecast probability
in each bin).
}
