% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permTestAnova.R, R/permTestAnova.default.R,
%   R/permTestAnova.formula.R
\name{permTestAnova}
\alias{permTestAnova}
\alias{permTestAnova.default}
\alias{permTestAnova.formula}
\title{Permutation test for ANOVA F-test}
\usage{
permTestAnova(x, ...)

\method{permTestAnova}{default}(
  x,
  group,
  B = 9999,
  plot.hist = TRUE,
  legend.loc = "topright",
  plot.qq = FALSE,
  ...
)

\method{permTestAnova}{formula}(formula, data = parent.frame(), subset, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{group}{a factor variable with two or more levels. If \code{group} is a
numeric vector, it will be coerced into a factor variable.}

\item{B}{the number of resamples (positive integer greater than 2).}

\item{plot.hist}{a logical value. If \code{TRUE}, the permutation
distribution of the statistic is plotted.}

\item{legend.loc}{location of the legend for the histogram. Options are
\code{"topleft"}, \code{"topright"}, \code{"bottomleft"} or
\code{"bottomright"}.}

\item{plot.qq}{a logical value. If \code{TRUE}, then a normal
quantile-quantile plot of the resampled test statistic is created.}

\item{formula}{a formula of the form \code{y ~ group} where \code{y} is
numeric and \code{group} is a factor variable.}

\item{data}{a data frame with the variables in the formula.}

\item{subset}{an optional expression specifying which observations to keep.}
}
\value{
Returns invisibly a vector of the replicates of the test statistic.
}
\description{
Permutation test to see if the population mean is the same for two or more
populations. For instance, test \eqn{latex}{H_0: \mu_1 = \mu_2 = \mu_3} where
\eqn{latex}{\mu} denotes the population mean. The values of the numeric
variable are randomly assigned to the groups and the ANOVA F statistic is
calculated. The command will print the mean and
standard error of the distribution of the test statistic as well as a
P-value.
}
\details{
Observations with missing values are removed.
}
\section{Methods (by class)}{
\itemize{
\item \code{permTestAnova(default)}: Permutation test for ANOVA F-test

\item \code{permTestAnova(formula)}: Permutation test for ANOVA F-test

}}
\examples{

permTestAnova(states03$ViolentCrime, states03$Region, B = 499)

#using formula syntax
\dontrun{
permTestAnova(ViolentCrime ~ Region, data = states03, B = 9999)
}

}
\references{
Tim Hesteberg's website:
\url{https://www.timhesterberg.net/bootstrap-and-resampling}
}
\author{
Adam Loy, Laura Chihara
}
\keyword{permutation}
\keyword{randomization}
\keyword{resampling}
\keyword{test}
