% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scope.R
\name{scope}
\alias{scope}
\title{Compute solution for SCOPE linear models.}
\usage{
scope(
  x,
  y,
  gamma = 8,
  sd = NULL,
  AIC = TRUE,
  mBICconstant = 25,
  default.lambdaseq = TRUE,
  default.length = 100,
  lambda.min.ratio = 0.01,
  lambdaseq = NULL,
  TerminateEpsilon = 1e-07,
  interceptxlinear = FALSE,
  max.iter = 1000,
  BICearlystop = TRUE,
  BICterminate = 20,
  silent = TRUE,
  K = 5,
  return.full.beta = FALSE,
  simply.cross.validated = FALSE,
  grid.safe = 10,
  blockorder = NULL,
  FoldAssignment = NULL
)
}
\arguments{
\item{x}{Data frame of covariates. Can include a mix of continuous and categorical covariates (no scaling of continuous covariates is performed within the program).
By default an intercept will be added; see interceptxlinear}

\item{y}{Response vector of length n}

\item{gamma}{Concavity parameter in MCP; see Zhang (2010) Nearly unbiased estimation with minimax concave penalty}

\item{sd}{Standard deviation of noise used for calibration of parameter lambda. This is recommended to be left alone}

\item{AIC}{Controls whether information criterion for early stopping is AIC (=TRUE) or mBIC (=FALSE)}

\item{mBICconstant}{If using mBIC, this is the parameter m}

\item{default.lambdaseq}{If using automatically generated sequence of lambda values set to TRUE. Do not set to FALSE without good reason}

\item{default.length}{Length of sequence of automatically generated lambda values}

\item{lambda.min.ratio}{Ratio of largest to smallest value on sequence of lambda values}

\item{lambdaseq}{If default.lambdaseq = FALSE then add path of lambda values here}

\item{TerminateEpsilon}{Epsilon for convergence criterion, is multiplied by null deviance to get terminate criterion for objective value}

\item{interceptxlinear}{If intercept is to be included in the model and is not in the column span of the continuous variables in x, set to FALSE (default).}

\item{max.iter}{Maximum number of iterations at each value of lambda}

\item{BICearlystop}{If information criterion is to be used to stop computation early, set to TRUE}

\item{BICterminate}{Specifies how many values of lambda to be computed after the minimum value of the information criterion is reached}

\item{silent}{If FALSE then progress updates will be printed as solutions are computed. Useful for tuning and diagnosing convergence issues.}

\item{K}{Number of folds in cross-validation. If K = 1, no cross-validation is performed}

\item{return.full.beta}{If TRUE then beta.full will be returned, else just the cross-validation optimal beta.best will be returned}

\item{simply.cross.validated}{If TRUE then cross-validation scores for each value of lambda will be returned, but not the estimates themselves}

\item{grid.safe}{As the automatically generated sequence of lambda values is adjusted during the first fold but fixed thereafter. For subsequent folds, this sets
computation to begin at a larger value of lambda to ensure that the first solution along the path is zero so as to maintain the advantages of the pathwise approach.
This specifies how many larger values of lambda should be used}

\item{blockorder}{By default the order in block coordinate descent is randomly sampled. Alternatively a permutation vector can be included here}

\item{FoldAssignment}{By default the assignments for cross-validation are randomly sampled automatically. Alternatively assignments can be included here}
}
\value{
A list of objects. Some may not be returned depending on value of arguments K, simply.cross.validated, return.full.beta.
\itemize{
\item lambdaseq - A matrix of the values of lambda used to compute the solution path. Columns correspond to different points on the path, rows correspond to the
categorical variables. Lambda is scaled depending on the number of categories present in the data.
\item cverrors - Provided K > 1 then the cross-validation error for each point on the grid will be returned
\item beta.full - Contains full solution path. If K > 1 then will only be returned if simply.cross.validated = FALSE and return.full.beta = TRUE.
First object [[ 1 ]] is coefficients of continuous variables, [[ 2 ]] is a list of coefficients for categorical variables
\item beta.best - Contains solution at CV-optimal point. Requires K > 1 to be returned. This must not be NULL in order to use predict.scope. First object [[ 1 ]] is
coefficients of continuous variables, [[ 2 ]] is a list of coefficients for categorical variables
\item fold.assign - Contains fold assignments for cross-validation
}
}
\description{
Computes solution for SCOPE linear models. Performs K-fold cross-validation for regularisation parameter lambda and can incorporate
both linear and categorical (including logical) variables. See Stokell, Shah and Tibshirani (2020).
}
\examples{
set.seed(1)
x = UniformDesignMatrix(100, 5, 8)
y = (x[ ,1 ] == "A1") + (x[ ,1 ] == "B1") +
    (x[ ,1 ] == "C1") + (x[ ,1 ] == "D1") +
    (x[ ,2 ] == "A2") + (x[ ,2 ] == "B2") +
    (x[ ,2 ] == "C2") + (x[ ,2 ] == "D2") + rnorm(100)
scope_mod = scope(x, y)
x_new = UniformDesignMatrix (10, 5, 8)
predict(scope_mod, x_new)

}
\references{
\insertRef{stokell2020modelling}{CatReg}
}
