% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_coords.R
\name{catr_get_code_from_coords}
\alias{catr_get_code_from_coords}
\title{Get the cadastral Municipality code from coordinates}
\usage{
catr_get_code_from_coords(x, srs, verbose = FALSE, cache_dir = NULL, ...)
}
\arguments{
\item{x}{It could be:
\itemize{
\item A pair of coordinates c(x,y).
\item A \CRANpkg{sf} object. See \strong{Details}.
}}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{wfs_service} column. See \strong{Details}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{cache_dir}{A path to a cache directory. On missing value the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{...}{
  Arguments passed on to \code{\link[mapSpain:esp_get_munic]{mapSpain::esp_get_munic_siane}}
  \describe{
    \item{\code{year}}{Release year. See \strong{Details} for years available.}
  }}
}
\value{
A \CRANpkg{tibble} with the format described in
\code{\link[=catr_ovc_get_cod_munic]{catr_ovc_get_cod_munic()}}.
}
\description{
This function takes as an input a pair of coordinates of a \CRANpkg{sf}
object and returns the corresponding municipality code for that coordinates.

See also \code{\link[mapSpain:esp_get_munic]{mapSpain::esp_get_munic_siane()}} and \code{\link[=catr_ovc_get_cod_munic]{catr_ovc_get_cod_munic()}}.
}
\details{
When \code{x} is a numeric vector, make sure that the \code{srs} matches the
coordinate values.

When \code{x} is a \CRANpkg{sf} object, only the first value would be used. The
function would extract the coordinates using
\code{sf::st_centroid(x, of_largest_polygon = TRUE)}.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Use with coords
catr_get_code_from_coords(c(-16.25462, 28.46824), srs = 4326)

# Use with sf
prov <- mapSpain::esp_get_prov("Caceres")
catr_get_code_from_coords(prov)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[mapSpain:esp_get_munic]{mapSpain::esp_get_munic_siane()}}, \code{\link[sf:geos_unary]{sf::st_centroid()}}.

Other search: 
\code{\link{catr_atom_search_munic}()},
\code{\link{catr_ovc_get_cod_munic}()},
\code{\link{catr_ovc_get_cod_provinces}()}
}
\concept{search}
